/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.hooks.BufferBuilderExt;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import org.jetbrains.annotations.Nullable;

public interface VertexConsumerProvider {
    public class_287 begin(class_293.class_5596 var1, class_293 var2);

    @Nullable
    public class_287.class_7433 build();

    public void close();

    public void clear();

    public static VertexConsumerProvider owned(int capacity) {
        return new OwnedVertexConsumerProvider(capacity);
    }

    public static VertexConsumerProvider shared() {
        return new SharedVertexConsumerProvider();
    }

    public static class OwnedVertexConsumerProvider
    implements VertexConsumerProvider {
        private class_287 bufferBuilder;

        public OwnedVertexConsumerProvider(int capacity) {
            this.bufferBuilder = new class_287(capacity);
        }

        @Override
        public class_287 begin(class_293.class_5596 mode, class_293 vertexFormat) {
            this.bufferBuilder.method_1328(mode, vertexFormat);
            return this.bufferBuilder;
        }

        @Override
        public class_287.class_7433 build() {
            return VersionUtils.helperOldBufferBuilderEndOrDiscard(this.bufferBuilder);
        }

        @Override
        public void close() {
            ((BufferBuilderExt)this.bufferBuilder).axiom$release();
            this.bufferBuilder = null;
        }

        @Override
        public void clear() {
            this.bufferBuilder.method_1343();
        }
    }

    public static class SharedVertexConsumerProvider
    implements VertexConsumerProvider {
        private class_287 bufferBuilder;

        @Override
        public class_287 begin(class_293.class_5596 mode, class_293 vertexFormat) {
            this.bufferBuilder = class_289.method_1348().method_1349();
            this.bufferBuilder.method_1328(mode, vertexFormat);
            return this.bufferBuilder;
        }

        @Override
        public class_287.class_7433 build() {
            return VersionUtils.helperOldBufferBuilderEndOrDiscard(this.bufferBuilder);
        }

        @Override
        public void close() {
            this.clear();
            this.bufferBuilder = null;
        }

        @Override
        public void clear() {
            this.bufferBuilder.method_1343();
        }
    }
}

